import toxi.geom.*;

int numSegments=40;
int maxNumLinks=100;
int depth=10;
int colorstep=10;
int alphastep=10;
float framesPerY;
float framesPerX;
int numWalkers=500;

ArrayList segs = new ArrayList();
ArrayList links = new ArrayList();
ArrayList tempsegs = new ArrayList();
ArrayList allnodes = new ArrayList();

Nodewalker[] walkers; 

import SimpleOpenNI.*;
SimpleOpenNI context;

void setup(){
  size(800,800,P3D);
  background(255);
  context = new SimpleOpenNI(this);
  // disable mirror
  context.setMirror(false);
  // enable depthMap generation 
  if(context.enableDepth() == false)
  {
     println("Can't open the depthMap, maybe the camera is not connected!"); 
     exit();
     return;
  }
  // enable skeleton generation for all joints
  context.enableUser(SimpleOpenNI.SKEL_PROFILE_ALL);
  
  frameRate(20);
  initialize();

} 

void draw(){
  background(255);

  translate(width/2,height/2,0);
  //rotateY(frameCount/framesPerY);
  //rotateX(frameCount/framesPerX);
  
  rotateX(rotX);
  rotateY(rotY);
  scale(zoomF);
  
  /*fill(255,50);
  noStroke();
  box(width);*/
  for(int i=0;i<segs.size();i++){
    ((Segment)segs.get(i)).draw();
  }
  fill(0,100);
  noStroke();
  for(int i=0;i<numWalkers;i++){
    walkers[i].update();
    walkers[i].draw();
  }

  context.update();
  // draw the skeleton if it's available
  int[] userList = context.getUsers();
  for(int i=0;i<userList.length;i++) {
    if(context.isTrackingSkeleton(userList[i]))
      drawSkeleton(userList[i]);
      
      PVector LeftHand  = new PVector();     PVector RightHand  = new PVector();
      PVector LeftElbow = new PVector();     PVector RightElbow = new PVector();
      float  confidence;
      int userId = userList[i]; 
      
      // get left and right hands, left and right elbows  // get the "sternum" coords 
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_LEFT_HAND,LeftHand); 
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_RIGHT_HAND,RightHand); 
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_LEFT_ELBOW,LeftElbow); 
      confidence = context.getJointPositionSkeleton(userId,SimpleOpenNI.SKEL_RIGHT_ELBOW,RightElbow); 

      // do zoom first
      //   50 - 42 = 18 *check*             -55   - ( - 42) = -18  ** need to check range on righthand/rightelbow 
      /*if ((LeftHand.x-LeftElbow.x) > 15 && (RightHand.x-RightElbow.x) > 15) {
         zoomF += 0.01f; 
         float diff1 = LeftHand.x-LeftElbow.x; float diff2 = RightHand.x-RightElbow.x;
         println("Zoom (+) Left: "+ diff1 + " Right: " + diff2);
      }
      if (-(LeftHand.x-LeftElbow.x) > 15 && -(RightHand.x-RightElbow.x) > 15) {
         zoomF -= 0.01f; 
         float diff1 = -(LeftHand.x-LeftElbow.x); float diff2 = -(RightHand.x-RightElbow.x);
         println("Zoom (-) Left: "+ diff1 + " Right: " + diff2);
      }*/
      println("["+LeftHand.x + ", "+ LeftElbow.x + "], [ "+RightHand.x +", "+ RightElbow.x + "] , ("+zoomF+")");  
      float diff1 = LeftHand.x-LeftElbow.x; float diff2 = RightHand.x-RightElbow.x;
      println("["+ diff1 + "], [ "+ diff2 + "]"); 

      if (diff1 > 20){
        zoomF += 0.01f;}
      else if (diff1 < -20){
        zoomF -= 0.01f;}
      /*else{
        if (abs(diff2) > 20){
          zoomF = .21+(diff2/20.0f);
        }
      }*/
      // diff1 = LeftHand.y-LeftElbow.y; diff2 = RightHand.y-RightElbow.y;
      // println("["+ diff1 + "], [ "+ diff2 + "]"); 
      // println("hi Pos1 Pos2 user length" + LeftHand + " "+RightHand + userList.length);
      // println("999rwh: "+bodyCenter);  //  X is left(+) right(-); Y is up down; Z is forward(0-600) towards sensor back is away from sensor (2000) 
  }
}

float d(Vec3D p1, Vec3D p2, Vec3D p3, Vec3D p4){
  return((p1.x-p2.x)*(p3.x-p4.x)+(p1.y-p2.y)*(p3.y-p4.y)+(p1.z-p2.z)*(p3.z-p4.z));

}

Segment closestLink(Segment s1, Segment s2){
  Segment result = null;
  Vec3D s1pStart = new Vec3D(s1.start.position);
  Vec3D s1pEnd = new Vec3D(s1.end.position);
  Vec3D s2pStart = new Vec3D(s2.start.position);
  Vec3D s2pEnd = new Vec3D(s2.end.position);
  float mu1 =  d(s1pStart,s2pStart,s2pEnd,s2pStart)*d(s2pEnd,s2pStart,s1pEnd,s1pStart);   
  mu1-=d(s1pStart,s2pStart,s1pEnd,s1pStart)*d(s2pEnd,s2pStart,s1pEnd,s1pStart); 
  mu1/=(d(s1pEnd,s1pStart,s1pEnd,s1pStart)*d(s2pEnd,s2pStart,s2pEnd,s2pStart)-d(s2pEnd,s2pStart,s1pEnd,s1pStart)*d(s2pEnd,s2pStart,s1pEnd,s1pStart));
  float mu2 =(d(s1pStart,s2pStart,s2pEnd,s2pStart)+mu1*d(s2pEnd,s2pStart,s1pEnd,s1pStart))/d(s2pEnd,s2pStart,s1pEnd,s1pStart);
  if((mu1>=0.0f)&&(mu1<=1.0f)&&(mu2>=0.0f)&&(mu2<=1.0f)){
    Vec3D p1 = ((s1pEnd.sub(s1pStart)).scale(mu1)).add(s1pStart);
    Vec3D p2 = ((s2pEnd.sub(s2pStart)).scale(mu2)).add(s2pStart);
    result =new Segment(p1,p2);
  }
  return result;

}

void initialize(){
  clearAll();
  for(int i=0;i<numSegments;i++){
    segs.add(new Segment(Vec3D.randomVector().scale(0.7f*width),Vec3D.randomVector().scale(0.7f*height)));
  }
  for(int i=0;i<segs.size();i++){
    for(int j=i+1;j<segs.size();j++){
      Segment sij = closestLink((Segment)segs.get(i),(Segment)segs.get(j));
      if ((sij != null)&&(links.size()<maxNumLinks)){

        ((Segment)segs.get(i)).start.add(sij.start);
        ((Segment)segs.get(i)).end.add(sij.start);
        ((Segment)segs.get(j)).start.add(sij.end);
        ((Segment)segs.get(j)).end.add(sij.end);
        sij.start.add(((Segment)segs.get(i)).start);
        sij.start.add(((Segment)segs.get(i)).end);
        sij.end.add(((Segment)segs.get(j)).start);
        sij.end.add(((Segment)segs.get(j)).end);
        links.add(sij);
      }
    }
  }
  for(int c=1;c<depth;c++){
    tempsegs.clear();
    tempsegs.addAll(segs);
    segs.clear();
    segs.addAll(links);
    links.clear();
    for(int i=0;i<segs.size();i++){
      for(int j=i+1;j<segs.size();j++){
        Segment sij = closestLink((Segment)segs.get(i),(Segment)segs.get(j));
        if ((sij != null)&&(links.size()<maxNumLinks)){

          ((Segment)segs.get(i)).start.add(sij.start);
          ((Segment)segs.get(i)).end.add(sij.start);
          ((Segment)segs.get(j)).start.add(sij.end);
          ((Segment)segs.get(j)).end.add(sij.end);
          sij.start.add(((Segment)segs.get(i)).start);
          sij.start.add(((Segment)segs.get(i)).end);
          sij.end.add(((Segment)segs.get(j)).start);
          sij.end.add(((Segment)segs.get(j)).end);
          links.add(sij);
        }
      }
    }

    for(int i=0;i<segs.size();i++){
      ((Segment)segs.get(i)).c=color(20+c*colorstep,0,0,20+c*alphastep);
    }
    segs.addAll(tempsegs);
  }

  framesPerY=random(200.0f,1000.0f)*((random(1.0)<0.5f)?-1.0f:1.0f);
  framesPerX=random(200.0f,1000.0f)*((random(1.0)<0.5f)?-1.0f:1.0f);
  for(int i=0;i<segs.size();i++){
    Segment si= (Segment)segs.get(i);
    allnodes.add(si.start);
    allnodes.add(si.end);
  }
  walkers = new Nodewalker[numWalkers];
  for(int i=0;i<numWalkers;i++){
    walkers[i] = new Nodewalker(allnodes);
  }


}
void clearAll(){
  segs.clear();
  links.clear();
  tempsegs.clear();
  allnodes.clear();
  
  }

void mouseClicked(){
initialize();

}

void keyPressed()
{
  switch(key)
  {
  case ' ':
    context.setMirror(!context.mirror());
    break;
  case 'p':
    System.out.println("  case 'p':");
    printSocialPoints();
    break;
  case 'r':
    System.out.println("  case 'r':");
    rwh_read_file();
    break;
  }
  switch(keyCode)
  {
    case LEFT:
      rotY += 0.1f;
      break;

    case RIGHT:
      // zoom out
      rotY -= 0.1f;
      break;
    case UP:
      if(keyEvent.isShiftDown())
        zoomF += 0.01f;
      else
        rotX += 0.1f;
      break;
    case DOWN:
      if(keyEvent.isShiftDown())
      {
        zoomF -= 0.01f;
        if(zoomF < 0.01)
          zoomF = 0.01;
      }
      else
        rotX -= 0.1f;
      break;
  }
}
